/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import java.util.List;
import java.util.Random;
import lotr.common.LOTRConfig;
import lotr.common.LOTRFoods;
import lotr.common.LOTRMod;
import lotr.common.block.LOTRBlockOrcBomb;
import lotr.common.entity.ai.LOTREntityAIDrink;
import lotr.common.entity.ai.LOTREntityAIEat;
import lotr.common.entity.ai.LOTREntityAIFollowHiringPlayer;
import lotr.common.entity.ai.LOTREntityAIHiredRemainStill;
import lotr.common.entity.ai.LOTREntityAINearestAttackableTargetOrc;
import lotr.common.entity.ai.LOTREntityAIOrcAvoidGoodPlayer;
import lotr.common.entity.ai.LOTREntityAIOrcSkirmish;
import lotr.common.entity.animal.LOTREntityDeer;
import lotr.common.entity.animal.LOTREntityRabbit;
import lotr.common.entity.item.LOTREntityOrcBomb;
import lotr.common.entity.npc.LOTREntityBlackUruk;
import lotr.common.entity.npc.LOTREntityDolGuldurUruk;
import lotr.common.entity.npc.LOTREntityGundabadUruk;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTREntityUrukHai;
import lotr.common.entity.npc.LOTRNames;
import lotr.common.entity.npc.LOTRSpeech;
import lotr.common.item.LOTRItemMug;
import lotr.common.world.biome.LOTRBiome;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public abstract class LOTREntityOrc
extends LOTREntityNPC {
    public boolean isWeakOrc = true;
    public boolean isStrongOrc = false;
    public boolean isStrongOrc1 = false;
    private int orcSkirmishTick;
    public EntityLivingBase currentRevengeTarget;

    public LOTREntityOrc(World world) {
        super(world);
        this.func_70105_a(0.5f, 1.55f);
        this.func_70661_as().func_75491_a(true);
        this.func_70661_as().func_75498_b(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new LOTREntityAIHiredRemainStill(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, LOTREntityOrcBomb.class, 12.0f, 1.5, 2.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new LOTREntityAIOrcAvoidGoodPlayer(this, 8.0f, 1.5));
        this.field_70714_bg.func_75776_a(4, this.createOrcAttackAI());
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new LOTREntityAIFollowHiringPlayer(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new LOTREntityAIEat(this, LOTRFoods.ORC, 6000));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new LOTREntityAIDrink(this, LOTRFoods.ORC_DRINK, 6000));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 8.0f, 0.05f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, LOTREntityNPC.class, 5.0f, 0.05f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        int target = this.addTargetTasks(true, LOTREntityAINearestAttackableTargetOrc.class);
        this.field_70715_bh.func_75776_a(target + 1, (EntityAIBase)new LOTREntityAIOrcSkirmish(this, true));
        if (!this.isOrcBombardier()) {
            this.field_70715_bh.func_75776_a(target + 2, (EntityAIBase)new LOTREntityAINearestAttackableTargetOrc(this, LOTREntityRabbit.class, 2000, false));
            this.field_70715_bh.func_75776_a(target + 2, (EntityAIBase)new LOTREntityAINearestAttackableTargetOrc(this, LOTREntityDeer.class, 2000, false));
        }
        this.spawnsInDarkness = true;
    }

    public abstract EntityAIBase createOrcAttackAI();

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(17, (Object)-1);
    }

    public boolean isOrcBombardier() {
        return false;
    }

    @Override
    public void setupNPCName() {
        this.familyInfo.setName(LOTRNames.getOrcName(this.field_70146_Z));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)MathHelper.func_76136_a((Random)this.field_70146_Z, (int)18, (int)24));
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(MathHelper.func_82716_a((Random)this.field_70146_Z, (double)0.2, (double)0.21));
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        return data;
    }

    @Override
    protected void onAttackModeChange(LOTREntityNPC.AttackMode mode, boolean mounted) {
        if (this.npcItemsInv.getBomb() != null) {
            this.func_70062_b(0, this.npcItemsInv.getBombingItem());
        } else if (mode == LOTREntityNPC.AttackMode.IDLE) {
            this.func_70062_b(0, this.npcItemsInv.getIdleItem());
        } else {
            this.func_70062_b(0, this.npcItemsInv.getMeleeWeapon());
        }
    }

    public int func_70658_aO() {
        if (this.isWeakOrc) {
            return MathHelper.func_76128_c((double)((double)super.func_70658_aO() * 0.75));
        }
        return super.func_70658_aO();
    }

    @Override
    public String getNPCName() {
        return this.familyInfo.getName();
    }

    public void func_70604_c(EntityLivingBase entity) {
        super.func_70604_c(entity);
        if (entity != null) {
            this.currentRevengeTarget = entity;
        }
    }

    @Override
    public void func_70636_d() {
        boolean flag;
        BiomeGenBase biome;
        int k;
        int j;
        int i;
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() == null) {
            this.currentRevengeTarget = null;
        }
        if (!this.field_70170_p.field_72995_K && this.isWeakOrc) {
            i = MathHelper.func_76128_c((double)this.field_70165_t);
            j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
            k = MathHelper.func_76128_c((double)this.field_70161_v);
            biome = this.field_70170_p.func_72807_a(i, k);
            boolean bl = flag = this.field_70170_p.func_72935_r() && this.field_70170_p.func_72937_j(i, j, k);
            if (biome instanceof LOTRBiome && ((LOTRBiome)biome).canSpawnHostilesInDay()) {
                flag = false;
            }
            if (flag && this.field_70173_aa % 20 == 0) {
                this.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 200, -1));
                this.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 200));
                this.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 200));
            }
        }
        if (!this.field_70170_p.field_72995_K && this.isStrongOrc) {
            i = MathHelper.func_76128_c((double)this.field_70165_t);
            j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
            k = MathHelper.func_76128_c((double)this.field_70161_v);
            biome = this.field_70170_p.func_72807_a(i, k);
            boolean bl = flag = this.field_70170_p.func_72935_r() && this.field_70170_p.func_72937_j(i, j, k);
            if (biome instanceof LOTRBiome && ((LOTRBiome)biome).canSpawnHostilesInDay()) {
                flag = true;
            }
            if (flag && this.field_70173_aa % 20 == 0) {
                this.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 200, 0));
                this.func_70690_d(new PotionEffect(Potion.field_76441_p.field_76415_H, 200, 0));
                this.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, 200, 2));
            }
        }
        if (!this.field_70170_p.field_72995_K && this.isStrongOrc1) {
            i = MathHelper.func_76128_c((double)this.field_70165_t);
            j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
            k = MathHelper.func_76128_c((double)this.field_70161_v);
            biome = this.field_70170_p.func_72807_a(i, k);
            boolean bl = flag = this.field_70170_p.func_72935_r() && this.field_70170_p.func_72937_j(i, j, k);
            if (biome instanceof LOTRBiome && ((LOTRBiome)biome).canSpawnHostilesInDay()) {
                flag = true;
            }
            if (flag && this.field_70173_aa % 20 == 0) {
                this.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 200, 0));
                this.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, 200, 1));
            }
        }
        if (!this.field_70170_p.field_72995_K && this.isOrcSkirmishing()) {
            if (!LOTRConfig.enableOrcSkirmish) {
                this.orcSkirmishTick = 0;
            } else if (!(this.func_70638_az() instanceof LOTREntityOrc)) {
                --this.orcSkirmishTick;
            }
        }
        if (this.isOrcBombardier()) {
            if (!this.field_70170_p.field_72995_K) {
                ItemStack bomb = this.npcItemsInv.getBomb();
                int meta = -1;
                if (bomb != null && Block.func_149634_a((Item)bomb.func_77973_b()) instanceof LOTRBlockOrcBomb) {
                    meta = bomb.func_77960_j();
                }
                this.field_70180_af.func_75692_b(17, (Object)((byte)meta));
            } else {
                byte meta = this.field_70180_af.func_75683_a(17);
                if (meta == -1) {
                    this.npcItemsInv.setBomb(null);
                } else {
                    this.npcItemsInv.setBomb(new ItemStack(LOTRMod.orcBomb, 1, (int)meta));
                }
            }
        }
    }

    public boolean canOrcSkirmish() {
        return !this.questInfo.anyActiveQuestPlayers();
    }

    public boolean isOrcSkirmishing() {
        return this.orcSkirmishTick > 0;
    }

    public void setOrcSkirmishing() {
        int prevSkirmishTick = this.orcSkirmishTick;
        this.orcSkirmishTick = 160;
        if (!this.field_70170_p.field_72995_K && prevSkirmishTick == 0) {
            List nearbyPlayers = this.field_70170_p.func_72872_a(EntityPlayer.class, this.field_70121_D.func_72314_b(24.0, 24.0, 24.0));
            for (Object nearbyPlayer : nearbyPlayers) {
                EntityPlayer entityplayer = (EntityPlayer)nearbyPlayer;
                LOTRSpeech.sendSpeech(entityplayer, this, LOTRSpeech.getRandomSpeechForPlayer(this, this.getOrcSkirmishSpeech(), entityplayer));
            }
        }
    }

    protected String getOrcSkirmishSpeech() {
        return "";
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("OrcSkirmish", this.orcSkirmishTick);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("OrcName")) {
            this.familyInfo.setName(nbt.func_74779_i("OrcName"));
        }
        this.orcSkirmishTick = nbt.func_74762_e("OrcSkirmish");
    }

    @Override
    protected float getPoisonedArrowChance() {
        return 0.06666667f;
    }

    @Override
    protected void func_70628_a(boolean flag, int i) {
        super.func_70628_a(flag, i);
        int flesh = this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(i + 1);
        for (int l = 0; l < flesh; ++l) {
            this.func_145779_a(Items.field_151078_bh, 1);
        }
        int bones = this.field_70146_Z.nextInt(2) + this.field_70146_Z.nextInt(i + 1);
        for (int l = 0; l < bones; ++l) {
            this.func_145779_a(LOTRMod.orcBone, 1);
        }
        if (this.field_70146_Z.nextInt(10) == 0) {
            int breads = 1 + this.field_70146_Z.nextInt(2) + this.field_70146_Z.nextInt(i + 1);
            for (int l = 0; l < breads; ++l) {
                this.func_145779_a(LOTRMod.maggotyBread, 1);
            }
        }
        if (flag) {
            int rareDropChance = 20 - i * 4;
            if (this.field_70146_Z.nextInt(rareDropChance = Math.max(rareDropChance, 1)) == 0) {
                int dropType = this.field_70146_Z.nextInt(2);
                if (dropType == 0) {
                    ItemStack orcDrink = new ItemStack(LOTRMod.mugOrcDraught);
                    orcDrink.func_77964_b(1 + this.field_70146_Z.nextInt(3));
                    LOTRItemMug.setVessel(orcDrink, LOTRFoods.ORC_DRINK.getRandomVessel(this.field_70146_Z), true);
                    this.func_70099_a(orcDrink, 0.0f);
                } else if (dropType == 1) {
                    int ingots = 1 + this.field_70146_Z.nextInt(2) + this.field_70146_Z.nextInt(i + 1);
                    for (int l = 0; l < ingots; ++l) {
                        if (this instanceof LOTREntityUrukHai || this instanceof LOTREntityGundabadUruk || this instanceof LOTREntityDolGuldurUruk) {
                            this.func_145779_a(LOTRMod.urukSteel, 1);
                            continue;
                        }
                        if (this instanceof LOTREntityBlackUruk) {
                            this.func_145779_a(LOTRMod.blackUrukSteel, 1);
                            continue;
                        }
                        this.func_145779_a(LOTRMod.orcSteel, 1);
                    }
                }
            }
        }
        this.dropOrcItems(flag, i);
    }

    protected void dropOrcItems(boolean flag, int i) {
    }

    @Override
    public boolean func_70601_bi() {
        if (super.func_70601_bi()) {
            if (this.liftSpawnRestrictions) {
                return true;
            }
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            BiomeGenBase biome = this.field_70170_p.func_72807_a(i, k);
            if (biome instanceof LOTRBiome && ((LOTRBiome)biome).isDwarvenBiome(this.field_70170_p)) {
                return this.field_70170_p.func_147439_a(i, j - 1, k) == biome.field_76752_A;
            }
            return true;
        }
        return false;
    }

    protected String func_70639_aQ() {
        return "lotr:orc.say";
    }

    protected String func_70621_aR() {
        return "lotr:orc.hurt";
    }

    protected String func_70673_aS() {
        return "lotr:orc.death";
    }

    @Override
    public ItemStack getHeldItemLeft() {
        if (this.isOrcBombardier() && this.npcItemsInv.getBomb() != null) {
            return this.npcItemsInv.getBomb();
        }
        return super.getHeldItemLeft();
    }
}

